VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cFluid"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Const ParticelCount As Long = 2000

Private FluidBodies(1 To ParticelCount) As cpBody
Private FluidShapes(1 To ParticelCount) As cpCircleShape

Private MaskSrf As cCairoSurface

Public Sub Construct(Optional ByVal Radius As Double = 1.35)
Dim i&, Mass As Double, Pat As cCairoPattern

  For i = 1 To ParticelCount
    Mass = Rnd + 0.2
    Set FluidBodies(i) = PhEngine.CreateBody(Mass, PhEngine.GetMomentForCircle(Mass, 0#, Radius, 0, 0))
      FluidBodies(i).V_Limit = 152 'since the Demo is "self-accelerating" (having a Damping-Value > 1 on the PhEngine)...
      FluidBodies(i).W_Limit = 50 '... we need to ensure, that our non-static Bodies are provided with some limits
    PhEngine.Space.AddBody FluidBodies(i), Int(Rnd * 700) + 50, Int(Rnd * 50) + 530
    
    Set FluidShapes(i) = FluidBodies(i).CreateCircleShape(Radius, 0, 0)
    PhEngine.Space.AddShape FluidShapes(i), 0.37, 0.2
  Next i
  
  'this preconstructed MaskSurface will increase the Drawing-Speed of our small Particel-Circles in the Draw()-Routine
  Set MaskSrf = Cairo.CreateSurface(Radius * 2 + 3, Radius * 2 + 3)
  With MaskSrf.CreateContext
    .TranslateDrawings MaskSrf.Width / 2, MaskSrf.Height / 2
    
    .Arc 0, 0, Radius + 1
    
    Set Pat = Cairo.CreateRadialPattern(0, 0, 0, 0, 0, Radius)
      Pat.AddColorStop 0, vbBlack, 0.25
      Pat.AddColorStop 0.3, vbBlack, 0.25
      Pat.AddColorStop 0.6, vbBlack, 0
      Pat.AddColorStop 0.7, vbBlack, 0.035
      Pat.AddColorStop 1, vbBlack, 0.065
    .Fill , Pat
  End With
End Sub

Public Sub Draw(CC As cCairoContext)
Dim i As Long, X As Double, Y As Double

  CC.SetSourceColor vbBlue 'set the Source for the AlphaMasks-Stamp
  
  For i = 1 To ParticelCount
    X = FluidShapes(i).tC_X
    Y = FluidShapes(i).tC_Y
    CC.MaskSurface MaskSrf, X - 3#, Y - 3# 'as said above... inside the loop we use only the fast Mask-Stamping-Call
  Next i

End Sub

